DediAutoSave = {};

DediAutoSave.metadata = {
	interface = "FS25 ...", --convert LS22 to LS25
	title = "DediAutoSave",
	notes = "Dieser Mod ist für Dedicated Server geeignet. Sobald der letzte Spieler den Server verlässt wird automatisch der Spielstand gespeichert.",
	author = "(by HappyLooser)",
	version = "1.0.0.0",
	build = 3,
	datum = " 28.12.2021",
	update = " 01.12.2024",
	web = "no",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function DediAutoSave:loadMap(mapName)		
	print("---loading ".. tostring(DediAutoSave.metadata.title).. " ".. tostring(DediAutoSave.metadata.version).. "(#".. tostring(DediAutoSave.metadata.build).. ") ".. tostring(DediAutoSave.metadata.author).. "---")	
	if g_dedicatedServer ~= nil then
		DediSave = {};
		function DediSave:update(dt)	
			if g_dedicatedServer ~= nil and g_currentMission.playerSystem ~= nil then 
				local playerSystem = g_currentMission.playerSystem;
				if self.dediSave_canSave == nil then	
					self.dediSave_canSave = false;
					self.dediSave_players = {};
					self.dediSave_g_currentMissionPlayers = {};
					self.dediSave_allowSave = false;
				end;			
				self.dediSave_g_currentMissionPlayers = {};
				local numPlayers = 0;
				for key, player in pairs(playerSystem.players) do
					numPlayers = numPlayers + 1;	
					table.insert(self.dediSave_g_currentMissionPlayers, player);
				end;				
				if numPlayers > 1 then
					self.dediSave_canSave = true;
					if not self.dediSave_allowSave then
						self.dediSave_allowSave = true;
					end;
				end;				
				if #self.dediSave_g_currentMissionPlayers > #playerSystem.players then		
					for i=1, #self.dediSave_g_currentMissionPlayers do
						local playerFound = false;			
						for j=1, #self.dediSave_players do
							if self.dediSave_g_currentMissionPlayers[i] == self.dediSave_players[j] then
								playerFound = true;
							end;
						end;
						
						if not playerFound then
							table.insert(self.dediSave_players, self.dediSave_g_currentMissionPlayers[i]);
							local player = playerSystem:getPlayerByUserId(self.dediSave_g_currentMissionPlayers[i].userId)
							if player ~= nil then								
								print("DediAutoSave: Player ".. player:getNickname().. " joined - current Player: ".. tostring(#self.dediSave_players));
							else
								print("DediAutoSave: Player joined - current Player: ".. tostring(#self.dediSave_players));
							end;							
						end;
					end;
					
				end;		
				if #self.dediSave_g_currentMissionPlayers < #self.dediSave_players then		
					for i=1, #self.dediSave_players do
						local playerFound = false;			
						for j=1, #self.dediSave_g_currentMissionPlayers do
							if self.dediSave_g_currentMissionPlayers[j] == self.dediSave_players[i] then
								playerFound = true;
							end;
						end;				
						if not playerFound then
							local player = playerSystem:getPlayerByUserId(self.dediSave_players[i].userId)
							if player ~= nil then	
								print("DediAutoSave: Player ".. player:getNickname().. " leave - current Player: ".. tostring(#self.dediSave_players-1));
							else
								print("DediAutoSave: Player leave - current Player: ".. tostring(#self.dediSave_players-1));
							end;							
							table.remove(self.dediSave_players, i);
							break;
						end;
					end;
				end;				
				if self.dediSave_canSave and numPlayers < 2 then
					print("DediSave: last Player leave, save current Game");
					self:saveSavegame(self.missionInfo, false);
					self.dediSave_canSave = false;
					self.dediSave_allowSave = false;
				end;
			end;
		end;
		local FSBaseMissionSaveSavegame = FSBaseMission.saveSavegame;
		FSBaseMission.saveSavegame = function(self, inst1)
			if self.dediSave_allowSave ~= nil then
				if not self.dediSave_allowSave then
					return;
				end;
			end;
			FSBaseMissionSaveSavegame(self, inst1);
		end;		
		BaseMission.update = Utils.prependedFunction(BaseMission.update, DediSave.update);			
	else	
		print("---".. tostring(DediAutoSave.metadata.title).. " not loaded for Client---");
	end;
end;
addModEventListener(DediAutoSave);